/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.core.sftp;

import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.virtualfs.VirtualFileSystemFactory;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.command.ScpCommandFactory;
import org.apache.sshd.server.shell.ProcessShellFactory;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.mule.munit.core.AbstractFTPServer;
import org.mule.munit.core.sftp.StreamKeyPairProvider;

public class SFTPServer
extends AbstractFTPServer {
    private SshServer sshd;

    public SFTPServer(int port, String username, String password, boolean anonymous, String homeDir) {
        super(homeDir);
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.sshd = SshServer.setUpDefaultServer();
        this.sshd.setPort(port);
        this.sshd.setFileSystemFactory((FileSystemFactory)new VirtualFileSystemFactory(this.getAdaptedPath(this.getHomeDir())));
        StreamKeyPairProvider fileKeyPairProvider = new StreamKeyPairProvider();
        this.sshd.setKeyPairProvider((KeyPairProvider)fileKeyPairProvider);
        SftpSubsystemFactory factory = new SftpSubsystemFactory();
        this.sshd.setSubsystemFactories(Arrays.asList(factory));
        this.sshd.setCommandFactory((CommandFactory)new ScpCommandFactory());
        this.sshd.setShellFactory((Factory)new ProcessShellFactory());
        this.sshd.setPasswordAuthenticator((PasswordAuthenticator)this.getUserManager(username, password, anonymous));
    }

    @Override
    public void start() {
        try {
            this.sshd.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not start the server", e);
        }
    }

    @Override
    public void stop() {
        try {
            this.sshd.stop();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not stop the server", e);
        }
        this.sshd = null;
    }
}

