/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.core.sftp;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import java.util.ArrayList;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.util.SecurityUtils;
import org.python.bouncycastle.openssl.PEMDecryptorProvider;
import org.python.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.python.bouncycastle.openssl.PEMKeyPair;
import org.python.bouncycastle.openssl.PEMParser;
import org.python.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.python.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamKeyPairProvider
extends AbstractKeyPairProvider {
    private static final Logger LOG = LoggerFactory.getLogger(StreamKeyPairProvider.class);

    public Iterable<KeyPair> loadKeys() {
        if (!SecurityUtils.isBouncyCastleRegistered()) {
            throw new IllegalStateException("BouncyCastle must be registered as a JCE provider");
        }
        ArrayList<KeyPair> keys = new ArrayList<KeyPair>();
        try {
            KeyPair kp = this.readPemFile();
            keys.add(kp);
        }
        catch (Exception e) {
            LOG.info("Unable to read key ", (Throwable)e);
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyPair readPemFile() throws IOException {
        try (PEMParser pemParser = new PEMParser((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/ftp-hostkey.pem")));){
            Object object = pemParser.readObject();
            PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build("".toCharArray());
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            KeyPair kp = object instanceof PEMEncryptedKeyPair ? converter.getKeyPair(((PEMEncryptedKeyPair)object).decryptKeyPair(decProv)) : converter.getKeyPair((PEMKeyPair)object);
            KeyPair keyPair = kp;
            return keyPair;
        }
    }
}

