/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.core;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.mule.munit.core.MockUserManagerAuthenticator;

public abstract class AbstractFTPServer {
    public static final String HOME_FOLDER_WILDCARD = "~";
    protected String homeDir;

    public AbstractFTPServer(String homeDir) {
        this.homeDir = homeDir != null && homeDir.startsWith(HOME_FOLDER_WILDCARD) ? System.getProperty("user.home") + StringUtils.substring((String)homeDir, (int)1) : homeDir;
    }

    public abstract void start();

    public abstract void stop();

    public String getHomeDir() {
        return this.homeDir;
    }

    public void remove(String path) {
        new File(this.getAbsolutePath(path)).delete();
    }

    public void containsFiles(String file, String path) {
        String absolutePath = this.getAbsolutePath(path);
        File[] filteredFiles = this.containsFilteredFiles(file, absolutePath);
        if (filteredFiles == null) {
            throw new RuntimeException("The path to the file does not exist or an I/O error has occurred");
        }
        Assert.assertTrue((String)"The file was not found in the folder", (filteredFiles.length > 0 ? 1 : 0) != 0);
    }

    private File[] containsFilteredFiles(String fileName, String path) {
        return new File(path).listFiles((file, name) -> name.startsWith(fileName));
    }

    private String getAbsolutePath(String path) {
        return StringUtils.isNotBlank((CharSequence)this.homeDir) ? this.homeDir + path : path;
    }

    protected String getAdaptedPath(String homeDir) {
        return homeDir == null ? "/" : homeDir;
    }

    protected MockUserManagerAuthenticator getUserManager(String username, String password, boolean anonymous) {
        return new MockUserManagerAuthenticator(username, password, anonymous, this.getAdaptedPath(this.getHomeDir()));
    }
}

