/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.core.ftp;

import org.apache.ftpserver.ConnectionConfig;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.listener.ListenerFactory;
import org.mule.munit.core.AbstractFTPServer;

public class FTPServer
extends AbstractFTPServer {
    private final FtpServer server;

    public FTPServer(int port, String username, String password, boolean anonymous, String homeDir) {
        super(homeDir);
        ListenerFactory listenerFactory = new ListenerFactory();
        listenerFactory.setPort(port);
        FtpServerFactory serverFactory = new FtpServerFactory();
        serverFactory.setConnectionConfig((ConnectionConfig)new MockConnectionConfig(anonymous));
        serverFactory.setUserManager((UserManager)this.getUserManager(username, password, anonymous));
        serverFactory.addListener("default", listenerFactory.createListener());
        this.server = serverFactory.createServer();
    }

    @Override
    public void start() {
        try {
            this.server.start();
        }
        catch (FtpException e) {
            throw new RuntimeException("Could not start FTP server", e);
        }
    }

    @Override
    public void stop() {
        this.server.stop();
    }

    private static class MockConnectionConfig
    implements ConnectionConfig {
        private final boolean anonymous;

        public MockConnectionConfig(boolean anonymous) {
            this.anonymous = anonymous;
        }

        public int getMaxThreads() {
            return 0;
        }

        public int getMaxLoginFailures() {
            return 0;
        }

        public int getLoginFailureDelay() {
            return 0;
        }

        public int getMaxAnonymousLogins() {
            return 100;
        }

        public int getMaxLogins() {
            return 0;
        }

        public boolean isAnonymousLoginEnabled() {
            return this.anonymous;
        }
    }
}

