/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.core.sftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;

public class MunitCommand
implements Command,
Runnable {
    private final String command;
    private final String message;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private ExitCallback callback;

    public MunitCommand(String command, String message) {
        this.command = ValidateUtils.checkNotNullAndNotEmpty((String)command, (String)"No command");
        this.message = ValidateUtils.checkNotNullAndNotEmpty((String)message, (String)"No message");
    }

    public String getCommand() {
        return this.command;
    }

    public String getMessage() {
        return this.message;
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    @Override
    public void run() {
        try {
            try {
                this.out.write(this.getMessage().getBytes(StandardCharsets.UTF_8));
                this.out.write(10);
            }
            finally {
                this.out.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.callback != null) {
            this.callback.onExit(0);
        }
    }

    public void start(ChannelSession channel, Environment env) throws IOException {
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }

    public void destroy(ChannelSession channel) {
    }

    public int hashCode() {
        return Objects.hashCode(this.getCommand());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return Objects.equals(this.getCommand(), ((MunitCommand)obj).getCommand());
    }

    public String toString() {
        return this.getMessage();
    }
}

