/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.core.sftp;

import java.io.File;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.virtualfs.VirtualFileSystemFactory;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.scp.server.ScpCommandFactory;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.command.CommandFactory;
import org.apache.sshd.server.shell.ProcessShellFactory;
import org.apache.sshd.server.shell.ShellFactory;
import org.apache.sshd.sftp.server.SftpSubsystemFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.mule.munit.core.AbstractFTPServer;
import org.mule.munit.core.sftp.MunitCommandFactory;
import org.mule.munit.core.sftp.StreamKeyPairProvider;

public class SFTPServer
extends AbstractFTPServer {
    private SshServer sshd;

    public SFTPServer(int port, String username, String password, boolean anonymous, String homeDir) {
        super(homeDir);
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.sshd = SshServer.setUpDefaultServer();
        this.sshd.setPort(port);
        this.sshd.setFileSystemFactory((FileSystemFactory)new VirtualFileSystemFactory(new File(this.getAdaptedPath(this.getHomeDir())).toPath()));
        StreamKeyPairProvider fileKeyPairProvider = new StreamKeyPairProvider();
        this.sshd.setKeyPairProvider((KeyPairProvider)fileKeyPairProvider);
        SftpSubsystemFactory factory = new SftpSubsystemFactory();
        this.sshd.setSubsystemFactories(Collections.singletonList(factory));
        ScpCommandFactory scpCommandFactory = new ScpCommandFactory();
        scpCommandFactory.setDelegateCommandFactory((CommandFactory)new MunitCommandFactory("/"));
        this.sshd.setCommandFactory((CommandFactory)scpCommandFactory);
        this.sshd.setShellFactory((ShellFactory)new ProcessShellFactory());
        this.sshd.setPasswordAuthenticator((PasswordAuthenticator)this.getUserManager(username, password, anonymous));
    }

    @Override
    public void start() {
        try {
            this.sshd.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not start the server", e);
        }
    }

    @Override
    public void stop() {
        try {
            this.sshd.stop();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not stop the server", e);
        }
        this.sshd = null;
    }
}

