/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.core.sftp;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Collections;
import java.util.Objects;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.python.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.python.bouncycastle.openssl.PEMKeyPair;
import org.python.bouncycastle.openssl.PEMParser;
import org.python.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.python.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamKeyPairProvider
extends AbstractKeyPairProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamKeyPairProvider.class);

    private KeyPair readPemFile() throws IOException {
        try (PEMParser pemParser = new PEMParser((Reader)new InputStreamReader(Objects.requireNonNull(((Object)((Object)this)).getClass().getResourceAsStream("/ftp-hostkey.pem"))));){
            Object object = pemParser.readObject();
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            if (object instanceof PEMEncryptedKeyPair) {
                KeyPair keyPair = converter.getKeyPair(((PEMEncryptedKeyPair)object).decryptKeyPair(new JcePEMDecryptorProviderBuilder().build("".toCharArray())));
                return keyPair;
            }
            KeyPair keyPair = converter.getKeyPair((PEMKeyPair)object);
            return keyPair;
        }
    }

    public Iterable<KeyPair> loadKeys(SessionContext session) throws IOException, GeneralSecurityException {
        if (!SecurityUtils.isBouncyCastleRegistered()) {
            throw new IllegalStateException("BouncyCastle must be registered as a JCE provider");
        }
        try {
            return Collections.singletonList(this.readPemFile());
        }
        catch (Exception e) {
            LOGGER.info("Unable to read key ", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

