/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.core;

import javax.net.ssl.HttpsURLConnection;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.Expectation;
import org.mockserver.serialization.ExpectationSerializer;
import org.mockserver.socket.tls.KeyStoreFactory;
import org.mule.munit.mockserver.MockServer;
import org.mule.munit.runner.component.rules.TestRule;
import org.mule.runtime.api.lifecycle.Disposable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MUnitMockServer
extends MockServer
implements Disposable,
TestRule {
    Logger logger = LoggerFactory.getLogger(MUnitMockServer.class);
    private final ExpectationSerializer expectationSerializer = new ExpectationSerializer(new MockServerLogger());
    public static final String PROXY_HOST = "localhost";
    public static final String HTTP_PROXY_HOST_PROPERTY = "http.proxyHost";
    public static final String HTTP_PROXY_PORT_PROPERTY = "http.proxyPort";
    public static final String HTTPS_PROXY_HOST_PROPERTY = "https.proxyHost";
    public static final String HTTPS_PROXY_PORT_PROPERTY = "https.proxyPort";
    public static final String USE_PROXY_PROPERTY = "com.ning.http.client.AsyncHttpClientConfig.useProxyProperties";

    public MUnitMockServer() {
        this.setProxyProperties();
        this.setMockServerKeyStoreFactory();
    }

    public void dispose() {
        super.stop();
    }

    public void reset() {
        super.reset();
    }

    private void setProxyProperties() {
        String port = super.getPort().toString();
        System.setProperty(HTTP_PROXY_HOST_PROPERTY, PROXY_HOST);
        System.setProperty(HTTPS_PROXY_HOST_PROPERTY, PROXY_HOST);
        System.setProperty(HTTP_PROXY_PORT_PROPERTY, port);
        System.setProperty(HTTPS_PROXY_PORT_PROPERTY, port);
        System.setProperty(USE_PROXY_PROPERTY, "true");
        this.logger.info("HTTP Mock Server running on localhost:" + port);
    }

    private void setMockServerKeyStoreFactory() {
        HttpsURLConnection.setDefaultSSLSocketFactory(new KeyStoreFactory(new MockServerLogger()).sslContext().getSocketFactory());
    }

    public void addExpectation(String jsonExpectations) {
        Expectation[] expectations = this.expectationSerializer.deserializeArray(jsonExpectations, true);
        super.addExpectation(expectations);
    }
}

