/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.core.utils;

import java.util.List;
import org.mockserver.model.HttpRequest;
import org.mule.munit.core.model.HttpMethod;
import org.mule.munit.core.model.RequestHeader;

public class MockServerUtils {
    private static final String HOST_HEADER_NAME = "Host";

    private MockServerUtils() {
    }

    public static HttpRequest buildRequest(HttpMethod method, String host, String path, List<RequestHeader> headers) {
        HttpRequest request = HttpRequest.request().withMethod(method.getName()).withHeader(HOST_HEADER_NAME, new String[]{host});
        if (path != null) {
            request.withPath(path);
        }
        if (headers != null) {
            headers.forEach(header -> request.withHeader(header.getHeader(), new String[]{header.getValue()}));
        }
        return request;
    }
}

