/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.extension;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import javax.inject.Inject;
import org.mockserver.model.HttpRequest;
import org.mule.munit.core.MUnitMockServer;
import org.mule.munit.core.model.HttpMethod;
import org.mule.munit.core.model.RequestHeader;
import org.mule.munit.core.utils.MockServerUtils;
import org.mule.munit.extension.MockRefConfig;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;

public class HTTPMockServerOperations {
    @Inject
    private MUnitMockServer server;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public void mock(@Expression(value=ExpressionSupport.REQUIRED) Object value) {
        try {
            String jsonValue = this.objectMapper.writeValueAsString(value);
            this.server.addExpectation(jsonValue);
        }
        catch (JsonProcessingException | IllegalArgumentException e) {
            throw new IllegalArgumentException("The mock configuration structure provided is not valid");
        }
    }

    @Alias(value="mock-ref")
    public void mockRef(@Alias(value="mock-config") @ParameterDsl(allowInlineDefinition=false) MockRefConfig config) {
        this.mock(config.getValue());
    }

    public void verify(HttpMethod method, String host, @Optional String path, @Optional List<RequestHeader> headers, @Optional Integer times) {
        HttpRequest request = MockServerUtils.buildRequest(method, host, path, headers);
        try {
            this.server.verify(request, times);
        }
        catch (AssertionError error) {
            String errorMessage = ((Throwable)((Object)error)).getMessage().isEmpty() ? "HTTP Spy Processor Failed" : ((Throwable)((Object)error)).getMessage();
            throw new AssertionError((Object)errorMessage);
        }
    }
}

