/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mockserver;

import org.mockserver.client.MockServerClient;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.integration.ClientAndServer;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpRequest;
import org.mockserver.verify.VerificationTimes;

public class MockServer {
    private ClientAndServer server;

    public MockServer() {
        ConfigurationProperties.attemptToProxyIfNoMatchingExpectation((boolean)true);
        this.server = ClientAndServer.startClientAndServer((Integer[])new Integer[0]);
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void addExpectation(Expectation[] expectations) {
        this.server.upsert(expectations);
    }

    public Integer getPort() {
        return this.server.getLocalPort();
    }

    public void reset() {
        if (this.server != null) {
            this.server.reset();
        }
    }

    public MockServerClient verify(HttpRequest request) throws AssertionError {
        return this.server.verify(new HttpRequest[]{request});
    }

    public MockServerClient verify(HttpRequest request, Integer times) throws AssertionError {
        if (times == null) {
            return this.verify(request);
        }
        return this.server.verify(request, VerificationTimes.exactly((int)times));
    }

    public ClientAndServer getServer() {
        return this.server;
    }
}

