/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit;


import org.mule.api.annotations.Configurable;

import java.util.Map;

/**
 * <p>Pojo Simplified Representation of a Mime Message</p>
 *
 * @author Mulesoft Inc.
 */
public class MimeMessage
{


    /**
     * <p>Message content</p>
     */
    @Configurable
    public Object withContent;

    /**
     * <p>Mime message headers</p>
     */
    @Configurable
    public Map<String, String> withHeaders;

    public Object getWithContent()
    {
        return withContent;
    }

    public void setWithContent(Object withContent)
    {
        this.withContent = withContent;
    }

    public Map<String, String> getWithHeaders()
    {
        return withHeaders;
    }

    public void setWithHeaders(Map<String, String> withHeaders)
    {
        this.withHeaders = withHeaders;
    }
}
