/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.NonAuthenticatedStateCommand;
import com.icegreen.greenmail.user.GreenMailUser;

class LoginCommand
extends NonAuthenticatedStateCommand {
    public static final String NAME = "LOGIN";
    public static final String ARGS = "<userid> <password>";

    LoginCommand() {
    }

    protected void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session) throws ProtocolException {
        String userid = this.parser.astring(request);
        String password = this.parser.astring(request);
        this.parser.endLine(request);
        if (session.getUserManager().test(userid, password)) {
            GreenMailUser user = session.getUserManager().getUser(userid);
            session.setAuthenticated(user);
            response.commandComplete(this);
        } else {
            response.commandFailed(this, "Invalid login/password");
        }
    }

    public String getName() {
        return NAME;
    }

    public String getArgSyntax() {
        return ARGS;
    }
}

