/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.config;

import org.mule.config.MuleManifest;
import org.mule.munit.config.GetReceivedMessagesDefinitionParser;
import org.mule.munit.config.MailServerModuleConfigDefinitionParser;
import org.mule.munit.config.StartServerDefinitionParser;
import org.mule.munit.config.StopServerDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

public class MailServerNamespaceHandler
extends NamespaceHandlerSupport {
    private static Logger logger = LoggerFactory.getLogger(MailServerNamespaceHandler.class);

    private void handleException(String beanName, String beanScope, NoClassDefFoundError noClassDefFoundError) {
        String muleVersion = "";
        try {
            muleVersion = MuleManifest.getProductVersion();
        }
        catch (Exception _x) {
            logger.error("Problem while reading mule version");
        }
        logger.error("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [mail-server] is not supported in mule " + muleVersion);
        throw new FatalBeanException("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [mail-server] is not supported in mule " + muleVersion, (Throwable)noClassDefFoundError);
    }

    public void init() {
        try {
            this.registerBeanDefinitionParser("config", (BeanDefinitionParser)new MailServerModuleConfigDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("config", "@Config", ex);
        }
        try {
            this.registerBeanDefinitionParser("start-server", (BeanDefinitionParser)new StartServerDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("start-server", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("stop-server", (BeanDefinitionParser)new StopServerDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("stop-server", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-received-messages", (BeanDefinitionParser)new GetReceivedMessagesDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("get-received-messages", "@Processor", ex);
        }
    }
}

