/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.AuthorizationException;
import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.AuthenticatedStateCommand;
import com.icegreen.greenmail.store.FolderException;

class RenameCommand
extends AuthenticatedStateCommand {
    public static final String NAME = "RENAME";
    public static final String ARGS = "existing-mailbox-name SPACE new-mailbox-name";

    RenameCommand() {
    }

    protected void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session) throws ProtocolException, FolderException, AuthorizationException {
        String existingName = this.parser.mailbox(request);
        String newName = this.parser.mailbox(request);
        this.parser.endLine(request);
        session.getHost().renameMailbox(session.getUser(), existingName, newName);
        session.unsolicitedResponses(response);
        response.commandComplete(this);
    }

    public String getName() {
        return NAME;
    }

    public String getArgSyntax() {
        return ARGS;
    }
}

