/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.smtp;

import com.icegreen.greenmail.smtp.SmtpHandler;
import com.icegreen.greenmail.util.InternetPrintWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class SmtpConnection {
    private static final int TIMEOUT_MILLIS = 30000;
    private InetAddress serverAddress;
    Socket sock;
    InetAddress clientAddress;
    InternetPrintWriter out;
    BufferedReader in;
    SmtpHandler handler;
    String heloName;

    public SmtpConnection(SmtpHandler handler, Socket sock) throws IOException {
        try {
            this.serverAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        this.sock = sock;
        sock.setSoTimeout(30000);
        this.clientAddress = sock.getInetAddress();
        OutputStream o = sock.getOutputStream();
        InputStream i = sock.getInputStream();
        this.out = new InternetPrintWriter(o, true);
        this.in = new BufferedReader(new InputStreamReader(i));
        this.handler = handler;
    }

    SmtpConnection() {
        try {
            this.serverAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void println(String line) {
        this.out.println(line);
    }

    public BufferedReader getReader() {
        return this.in;
    }

    public String readLine() throws IOException {
        String line = this.in.readLine();
        return line;
    }

    public String getClientAddress() {
        return this.clientAddress.getHostName();
    }

    public InetAddress getServerAddress() {
        return this.serverAddress;
    }

    public String getServerGreetingsName() {
        InetAddress serverAddress = this.getServerAddress();
        if (serverAddress != null) {
            return serverAddress.toString();
        }
        return System.getProperty("user.name");
    }

    public String getHeloName() {
        return this.heloName;
    }

    public void setHeloName(String n) {
        this.heloName = n;
    }

    public void quit() {
        this.handler.quit();
    }
}

