/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.foedus.util;

import com.icegreen.greenmail.foedus.util.Resource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public class StringBufferResource
implements Resource {
    StringWriter _currentWriter;
    StringBuffer _contentBuffer;

    public StringBufferResource() {
    }

    public StringBufferResource(String initalValue) {
        this._contentBuffer = new StringBuffer(initalValue);
    }

    public Writer getWriter() throws IOException {
        this._currentWriter = new StringWriter();
        return this._currentWriter;
    }

    public InputStream getInputStream() throws IOException {
        this.closeInput();
        return new ByteArrayInputStream(this._contentBuffer.toString().getBytes());
    }

    public Reader getReader() throws IOException {
        this.closeInput();
        return new StringReader(this._contentBuffer.toString());
    }

    private void closeInput() throws IOException {
        if (this._currentWriter != null) {
            this._contentBuffer = this._currentWriter.getBuffer();
            this._currentWriter = null;
        }
        if (this._contentBuffer == null) {
            throw new IOException("No content has been written");
        }
    }

    public long getSize() {
        return this._contentBuffer.toString().length();
    }

    public String getAsString() throws IOException {
        this.closeInput();
        return this._contentBuffer.toString();
    }

    public void delete() {
        this._contentBuffer = null;
        this._currentWriter = null;
    }
}

