/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit;

import org.mule.api.MuleException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.schedule.Scheduler;
import org.mule.transport.polling.MessageProcessorPollingMessageReceiver;

/**
 * Created by  on 2/14/14.
 *
 * @author Mulesoft Inc.
 */
public class MunitScheduler implements Scheduler {
    private MessageProcessorPollingMessageReceiver job;
    private Scheduler wrappedScheduler;

    public MunitScheduler(Scheduler scheduler, MessageProcessorPollingMessageReceiver job) {
        this.wrappedScheduler = scheduler;
        this.job = job;
    }

    @Override
    public void schedule() throws Exception {
        job.poll();
    }

    @Override
    public void dispose() {
        this.wrappedScheduler.dispose();
    }

    @Override
    public void initialise() throws InitialisationException {
        this.wrappedScheduler.initialise();
    }

    @Override
    public void start() throws MuleException {
        //DO nothing
    }

    @Override
    public void stop() throws MuleException {
        this.wrappedScheduler.stop();
    }

    @Override
    public void setName(String s) {
       this.wrappedScheduler.setName(s);
    }

    @Override
    public String getName() {
        return this.wrappedScheduler.getName();
    }
}
