
package org.mule.munit.processors;

import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.devkit.processor.DevkitBasedMessageProcessor;
import org.mule.munit.MClient;
import org.mule.munit.adapters.MClientProcessAdapter;
import org.mule.security.oauth.callback.ProcessCallback;


/**
 * DispatchMessageProcessor invokes the {@link org.mule.munit.MClient#dispatch(java.lang.String, java.util.Map, java.lang.Object)} method in {@link MClient }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.5.3", date = "2018-07-03T09:28:12-04:00", comments = "Build UNNAMED.2049.ec39f2b")
public class DispatchMessageProcessor
    extends DevkitBasedMessageProcessor
    implements MessageProcessor
{

    protected Object path;
    protected String _pathType;
    protected Object parameters;
    protected Map<String, Object> _parametersType;
    protected Object payload;
    protected Object _payloadType;

    public DispatchMessageProcessor(String operationName) {
        super(operationName);
    }

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    @Override
    public void start()
        throws MuleException
    {
        super.start();
    }

    @Override
    public void stop()
        throws MuleException
    {
        super.stop();
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    /**
     * Sets path
     * 
     * @param value Value to set
     */
    public void setPath(Object value) {
        this.path = value;
    }

    /**
     * Sets payload
     * 
     * @param value Value to set
     */
    public void setPayload(Object value) {
        this.payload = value;
    }

    /**
     * Sets parameters
     * 
     * @param value Value to set
     */
    public void setParameters(Object value) {
        this.parameters = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws Exception
     */
    public MuleEvent doProcess(final MuleEvent event)
        throws Exception
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(MClientProcessAdapter.class, false, event);
            final String _transformedPath = ((String) evaluateAndTransform(getMuleContext(), event, DispatchMessageProcessor.class.getDeclaredField("_pathType").getGenericType(), null, path));
            final Map<String, Object> _transformedParameters = ((Map<String, Object> ) evaluateAndTransform(getMuleContext(), event, DispatchMessageProcessor.class.getDeclaredField("_parametersType").getGenericType(), null, parameters));
            final Object _transformedPayload = ((Object) evaluateAndTransform(getMuleContext(), event, DispatchMessageProcessor.class.getDeclaredField("_payloadType").getGenericType(), null, payload));
            final ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class<? extends Exception>> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    ((MClient) object).dispatch(_transformedPath, _transformedParameters, _transformedPayload);
                    return null;
                }

            }
            , this, event);
            return event;
        } catch (Exception e) {
            throw e;
        }
    }

}
