
package org.mule.munit.processors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.NestedProcessor;
import org.mule.api.devkit.NestedProcessorChain;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.devkit.processor.DevkitBasedMessageProcessor;
import org.mule.munit.MClient;
import org.mule.munit.adapters.MClientProcessAdapter;
import org.mule.security.oauth.callback.ProcessCallback;


/**
 * SendMessageProcessor invokes the {@link org.mule.munit.MClient#send(java.lang.String, java.lang.Object, java.lang.Long, java.util.Map, java.util.List)} method in {@link MClient }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.5.3", date = "2018-07-03T09:28:12-04:00", comments = "Build UNNAMED.2049.ec39f2b")
public class SendMessageProcessor
    extends DevkitBasedMessageProcessor
    implements MessageProcessor
{

    protected Object url;
    protected String _urlType;
    protected Object payload;
    protected Object _payloadType;
    protected Object timeout;
    protected Long _timeoutType;
    protected Object messageProperties;
    protected Map<String, Object> _messagePropertiesType;
    protected Object responseProcessing;
    protected List<NestedProcessor> _responseProcessingType;

    public SendMessageProcessor(String operationName) {
        super(operationName);
    }

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
        if (responseProcessing instanceof List) {
            for (MessageProcessor messageProcessor: ((List<MessageProcessor> ) responseProcessing)) {
                if (messageProcessor instanceof Initialisable) {
                    ((Initialisable) messageProcessor).initialise();
                }
            }
        }
    }

    @Override
    public void start()
        throws MuleException
    {
        super.start();
        if (responseProcessing instanceof List) {
            for (MessageProcessor messageProcessor: ((List<MessageProcessor> ) responseProcessing)) {
                if (messageProcessor instanceof Startable) {
                    ((Startable) messageProcessor).start();
                }
            }
        }
    }

    @Override
    public void stop()
        throws MuleException
    {
        super.stop();
        if (responseProcessing instanceof List) {
            for (MessageProcessor messageProcessor: ((List<MessageProcessor> ) responseProcessing)) {
                if (messageProcessor instanceof Stoppable) {
                    ((Stoppable) messageProcessor).stop();
                }
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (responseProcessing instanceof List) {
            for (MessageProcessor messageProcessor: ((List<MessageProcessor> ) responseProcessing)) {
                if (messageProcessor instanceof Disposable) {
                    ((Disposable) messageProcessor).dispose();
                }
            }
        }
    }

    /**
     * Sets messageProperties
     * 
     * @param value Value to set
     */
    public void setMessageProperties(Object value) {
        this.messageProperties = value;
    }

    /**
     * Sets payload
     * 
     * @param value Value to set
     */
    public void setPayload(Object value) {
        this.payload = value;
    }

    /**
     * Sets url
     * 
     * @param value Value to set
     */
    public void setUrl(Object value) {
        this.url = value;
    }

    /**
     * Sets timeout
     * 
     * @param value Value to set
     */
    public void setTimeout(Object value) {
        this.timeout = value;
    }

    /**
     * Sets responseProcessing
     * 
     * @param value Value to set
     */
    public void setResponseProcessing(Object value) {
        this.responseProcessing = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws Exception
     */
    public MuleEvent doProcess(final MuleEvent event)
        throws Exception
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(MClientProcessAdapter.class, false, event);
            final String _transformedUrl = ((String) evaluateAndTransform(getMuleContext(), event, SendMessageProcessor.class.getDeclaredField("_urlType").getGenericType(), null, url));
            final Object _transformedPayload = ((Object) evaluateAndTransform(getMuleContext(), event, SendMessageProcessor.class.getDeclaredField("_payloadType").getGenericType(), null, payload));
            final Long _transformedTimeout = ((Long) evaluateAndTransform(getMuleContext(), event, SendMessageProcessor.class.getDeclaredField("_timeoutType").getGenericType(), null, timeout));
            final Map<String, Object> _transformedMessageProperties = ((Map<String, Object> ) evaluateAndTransform(getMuleContext(), event, SendMessageProcessor.class.getDeclaredField("_messagePropertiesType").getGenericType(), null, messageProperties));
            final List<NestedProcessor> _transformedResponseProcessing = new ArrayList<NestedProcessor>();
            if (responseProcessing!= null) {
                for (MessageProcessor messageProcessor: ((List<MessageProcessor> ) responseProcessing)) {
                    _transformedResponseProcessing.add(new NestedProcessorChain(event, getMuleContext(), messageProcessor));
                }
            }
            Object resultPayload;
            final ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class<? extends Exception>> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((MClient) object).send(_transformedUrl, _transformedPayload, _transformedTimeout, _transformedMessageProperties, _transformedResponseProcessing);
                }

            }
            , this, event);
            event.getMessage().setPayload(resultPayload);
            return event;
        } catch (Exception e) {
            throw e;
        }
    }

}
