/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit;

import java.util.Collection;
import org.mule.api.MuleContext;
import org.mule.api.registry.RegistrationException;
import org.mule.api.schedule.Scheduler;
import org.mule.api.schedule.SchedulerFactoryPostProcessor;
import org.mule.api.schedule.Schedulers;
import org.mule.munit.MunitScheduler;
import org.mule.transport.PollingReceiverWorker;
import org.mule.transport.polling.MessageProcessorPollingMessageReceiver;

public class MunitPollManager {
    private MuleContext muleContext;

    public static MunitPollManager instance(MuleContext context) {
        return new MunitPollManager(context);
    }

    static Scheduler postProcessSchedulerFactory(Object job, Scheduler scheduler) {
        if (job instanceof PollingReceiverWorker) {
            return new MunitScheduler(scheduler, (MessageProcessorPollingMessageReceiver)((PollingReceiverWorker)job).getReceiver());
        }
        return scheduler;
    }

    public MunitPollManager(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public void avoidPollLaunch() {
        try {
            this.muleContext.getRegistry().registerObject("__Munit_Poll_Stopper", (Object)new SchedulerFactoryPostProcessor(){

                public Scheduler process(Object o, Scheduler scheduler) {
                    return MunitPollManager.postProcessSchedulerFactory(o, scheduler);
                }
            });
        }
        catch (RegistrationException e) {
            throw new RuntimeException("Could not stop polls");
        }
    }

    public void schedulePoll(String flowName) throws Exception {
        Scheduler scheduler = this.getScheduler(flowName);
        scheduler.schedule();
    }

    public void stopPoll(String flowName) throws Exception {
        Scheduler scheduler = this.getScheduler(flowName);
        scheduler.stop();
    }

    public void startPoll(String flowName) throws Exception {
        Scheduler scheduler = this.getScheduler(flowName);
        scheduler.start();
    }

    private Scheduler getScheduler(String flowName) throws Exception {
        Collection schedulers = this.muleContext.getRegistry().lookupScheduler(Schedulers.flowConstructPollingSchedulers((String)flowName));
        if (schedulers.isEmpty()) {
            throw new Exception("Flow " + flowName + " does not exist");
        }
        return (Scheduler)schedulers.iterator().next();
    }
}

