/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.config;

import org.mule.config.MuleManifest;
import org.mule.munit.config.CallDefinitionParser;
import org.mule.munit.config.DispatchDefinitionParser;
import org.mule.munit.config.MClientConfigDefinitionParser;
import org.mule.munit.config.RequestDefinitionParser;
import org.mule.munit.config.SchedulePollDefinitionParser;
import org.mule.munit.config.SendDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

public class MclientNamespaceHandler
extends NamespaceHandlerSupport {
    private static Logger logger = LoggerFactory.getLogger(MclientNamespaceHandler.class);

    private void handleException(String beanName, String beanScope, NoClassDefFoundError noClassDefFoundError) {
        String muleVersion = "";
        try {
            muleVersion = MuleManifest.getProductVersion();
        }
        catch (Exception _x) {
            logger.error("Problem while reading mule version");
        }
        logger.error("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [mclient] is not supported in mule " + muleVersion);
        throw new FatalBeanException("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [mclient] is not supported in mule " + muleVersion, (Throwable)noClassDefFoundError);
    }

    public void init() {
        try {
            this.registerBeanDefinitionParser("config", (BeanDefinitionParser)new MClientConfigDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("config", "@Config", ex);
        }
        try {
            this.registerBeanDefinitionParser("call", (BeanDefinitionParser)new CallDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("call", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("dispatch", (BeanDefinitionParser)new DispatchDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("dispatch", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("request", (BeanDefinitionParser)new RequestDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("request", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("send", (BeanDefinitionParser)new SendDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("send", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("schedule-poll", (BeanDefinitionParser)new SchedulePollDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("schedule-poll", "@Processor", ex);
        }
    }
}

