/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit;

import java.util.List;
import java.util.Map;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.NestedProcessor;
import org.mule.api.client.AbstractBaseOptionsBuilder;
import org.mule.api.client.OperationOptions;
import org.mule.api.client.SimpleOptionsBuilder;
import org.mule.api.context.MuleContextAware;
import org.mule.api.schedule.Scheduler;
import org.mule.api.schedule.SchedulerFactoryPostProcessor;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.munit.MunitPollManager;

public class MClient
implements MuleContextAware,
SchedulerFactoryPostProcessor {
    public static final String HTTP_METHOD = "http.method";
    public static final String HTTP_FOLLOWS_REDIRECT = "http.follows.redirect";
    private MuleContext muleContext;
    private Boolean stopPollsByDefault;
    private MunitPollManager pollManager;

    private AbstractBaseOptionsBuilder getOptionsBuilder(String path, Map<String, Object> parameters) {
        if (path.startsWith("http") || path.startsWith("https")) {
            HttpRequestOptionsBuilder options = HttpRequestOptionsBuilder.newOptions();
            if (parameters != null) {
                HttpRequestOptionsBuilder httpRequestOptionsBuilder = options = parameters.get(HTTP_METHOD) != null ? options.method((String)parameters.get(HTTP_METHOD)) : options.method("GET");
                if (parameters.get(HTTP_FOLLOWS_REDIRECT) != null) {
                    options = "true".equals(parameters.get(HTTP_FOLLOWS_REDIRECT)) ? options.enableFollowsRedirect() : options.disableFollowsRedirect();
                }
            }
            return options;
        }
        return SimpleOptionsBuilder.newOptions();
    }

    public Object call(String path, Map<String, Object> parameters, Object payload, List<NestedProcessor> responseProcessing) throws Exception {
        MuleMessage response;
        AbstractBaseOptionsBuilder options = this.getOptionsBuilder(path, parameters);
        DefaultMuleMessage message = new DefaultMuleMessage(payload, parameters, this.muleContext);
        Object processedResponse = response = this.muleContext.getClient().send(path, (MuleMessage)message, (OperationOptions)options.build());
        if (responseProcessing != null) {
            for (NestedProcessor processor : responseProcessing) {
                processedResponse = processor.process(processedResponse);
            }
        }
        return processedResponse;
    }

    public void dispatch(String path, Map<String, Object> parameters, Object payload) throws Exception {
        AbstractBaseOptionsBuilder options = this.getOptionsBuilder(path, parameters);
        DefaultMuleMessage message = new DefaultMuleMessage(payload, parameters, this.muleContext);
        this.muleContext.getClient().dispatch(path, (MuleMessage)message, (OperationOptions)options.build());
    }

    public Object request(String url, Long timeout, List<NestedProcessor> responseProcessing) throws Exception {
        MuleMessage response;
        Object processedResponse = response = this.muleContext.getClient().request(url, timeout.longValue());
        if (responseProcessing != null) {
            for (NestedProcessor processor : responseProcessing) {
                processedResponse = processor.process(processedResponse);
            }
        }
        return processedResponse;
    }

    public Object send(String url, Object payload, Long timeout, Map<String, Object> messageProperties, List<NestedProcessor> responseProcessing) throws Exception {
        MuleMessage response;
        AbstractBaseOptionsBuilder options = this.getOptionsBuilder(url, messageProperties);
        options = ((HttpRequestOptionsBuilder)options).responseTimeout(timeout.longValue());
        DefaultMuleMessage message = new DefaultMuleMessage(payload, messageProperties, this.muleContext);
        Object processedResponse = response = this.muleContext.getClient().send(url, (MuleMessage)message, (OperationOptions)options.build());
        if (responseProcessing != null) {
            for (NestedProcessor processor : responseProcessing) {
                processedResponse = processor.process(processedResponse);
            }
        }
        return processedResponse;
    }

    public void schedulePoll(String ofFlow) throws Exception {
        this.pollManager.schedulePoll(ofFlow);
    }

    public Scheduler process(Object o, Scheduler scheduler) {
        if (this.stopPollsByDefault.booleanValue()) {
            return MunitPollManager.postProcessSchedulerFactory(o, scheduler);
        }
        return scheduler;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        this.pollManager = new MunitPollManager(context);
    }

    public void setStopPollsByDefault(Boolean stopPollsByDefault) {
        this.stopPollsByDefault = stopPollsByDefault;
    }

    public Boolean getStopPollsByDefault() {
        return this.stopPollsByDefault;
    }
}

