/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule;


import org.mule.api.context.notification.AsyncMessageNotificationListener;
import org.mule.context.notification.AsyncMessageNotification;

import java.util.concurrent.atomic.AtomicInteger;

public class AsyncSynchronizeListener implements AsyncMessageNotificationListener<AsyncMessageNotification>, Synchronize {

    AtomicInteger asyncCount = new AtomicInteger(0);

    @Override
    public void onNotification(AsyncMessageNotification notification) {
//        String notificationRootId = ((MuleEvent) notification.getSource()).getMessage().getMessageRootId();


        if (notification.getAction() == AsyncMessageNotification.PROCESS_ASYNC_SCHEDULED) {
            asyncCount.incrementAndGet();
        } else {
            asyncCount.decrementAndGet();
        }
    }

    public AtomicInteger getAsyncCount() {
        return asyncCount;
    }

    @Override
    public synchronized boolean readyToContinue() {
        return asyncCount.get() <= 0;
    }
}
