/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule;

import com.mulesoft.module.batch.api.notification.BatchNotification;
import com.mulesoft.module.batch.api.notification.BatchNotificationListener;
import org.mule.api.context.notification.ServerNotification;

import java.util.concurrent.atomic.AtomicInteger;

public class BatchSynchronizeListener implements BatchNotificationListener, Synchronize {

    AtomicInteger count = new AtomicInteger(0);

    @Override
    public void onNotification(ServerNotification serverNotification) {
        if (serverNotification.getAction() == BatchNotification.INPUT_PHASE_BEGIN) {
            count.incrementAndGet();
        }

        if (serverNotification.getAction() == BatchNotification.INPUT_PHASE_FAILED ||
                serverNotification.getAction() == BatchNotification.LOAD_PHASE_FAILED ||
                serverNotification.getAction() == BatchNotification.JOB_PROCESS_RECORDS_FAILED ||
                serverNotification.getAction() == BatchNotification.ON_COMPLETE_FAILED ||
                serverNotification.getAction() == BatchNotification.JOB_SUCCESSFUL ||
                serverNotification.getAction() == BatchNotification.JOB_STOPPED) {

            count.decrementAndGet();
        }
    }

    @Override
    public synchronized boolean readyToContinue() {
        return count.get() <= 0;
    }
}
