/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule;

import org.mule.api.context.notification.PipelineMessageNotificationListener;
import org.mule.context.notification.PipelineMessageNotification;

import java.util.concurrent.atomic.AtomicInteger;

public class PipelineSynchronizeListener implements PipelineMessageNotificationListener<PipelineMessageNotification>, Synchronize {

    AtomicInteger count = new AtomicInteger(0);

    @Override
    public void onNotification(PipelineMessageNotification notification) {
//        String notificationRootId = ((MuleEvent) notification.getSource()).getMessage().getMessageRootId();

        if (notification.getAction() == PipelineMessageNotification.PROCESS_START) {
            count.incrementAndGet();
        }
        if (notification.getAction() == PipelineMessageNotification.PROCESS_END) {
            count.decrementAndGet();
        }
    }

    @Override
    public synchronized boolean readyToContinue() {
        return count.get() <= 0;
    }
}
