/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

/**
 *
 */
public abstract class Synchronizer
{

    private MuleContext muleContext;
    private long timeout;

    public Synchronizer(MuleContext muleContext, long timeout)
    {
        this.muleContext = muleContext;
        this.timeout = timeout;
    }

    public MuleEvent runAndWait(MuleEvent event) throws Exception
    {
        final AsyncSynchronizeListener asyncListener = new AsyncSynchronizeListener();
        final PipelineSynchronizeListener pipelineListener = new PipelineSynchronizeListener();
        final BatchSynchronizeListener batchListener  = new BatchSynchronizeListener();

        muleContext.registerListener(asyncListener);
        muleContext.registerListener(pipelineListener);
        muleContext.registerListener(batchListener);

        MuleEvent returnObject = process(event);

        try
        {
            new SynchronizeProber(timeout, PollingProber.DEFAULT_POLLING_INTERVAL).check(new Probe()
            {
                @Override
                public boolean isSatisfied()
                {
                    return asyncListener.readyToContinue() && pipelineListener.readyToContinue() && batchListener.readyToContinue();
                }

                @Override
                public String describeFailure()
                {
                    return "Time out waiting for async executions";
                }
            });
        }
        finally
        {
            muleContext.unregisterListener(asyncListener);
            muleContext.unregisterListener(pipelineListener);
            muleContext.unregisterListener(batchListener);
        }

        return returnObject;
    }

    protected abstract MuleEvent process(MuleEvent event) throws Exception;
}
