/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.config;

import org.mule.DefaultMuleEvent;
import org.mule.MessageExchangePattern;
import org.mule.Synchronizer;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;

/**
 *
 */
public class RunAndWait implements MessageProcessor, Initialisable
{
    private long timeout;
    private boolean runAsync;
    private MessageProcessor messageProcessor;

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException
    {
        MuleEvent processingEvent= event;
        if ( runAsync )
        {
            processingEvent = new DefaultMuleEvent(event.getMessage(), MessageExchangePattern.ONE_WAY,
                                                   event.getFlowConstruct(), event.getSession());
        }

        Synchronizer synchronizer = new Synchronizer(event.getMuleContext(), timeout)
        {

            @Override
            protected MuleEvent process(MuleEvent event) throws Exception
            {
                return messageProcessor.process(event);
            }
        };

        try
        {
            return synchronizer.runAndWait(processingEvent);
        }
        catch (Exception e)
        {
            throw new DefaultMuleException(e);
        }
    }

    public void setMessageProcessor(MessageProcessor messageProcessor)
    {
        this.messageProcessor = messageProcessor;
    }

    public void setRunAsync(boolean runAsync)
    {
        this.runAsync = runAsync;
    }

    public void setTimeout(long timeout)
    {
        this.timeout = timeout;
    }

    @Override
    public void initialise() throws InitialisationException {
        if(messageProcessor instanceof Initialisable) {
            ((Initialisable) messageProcessor).initialise();
        }
    }
}