/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import com.mulesoft.module.batch.api.notification.BatchNotification;
import com.mulesoft.module.batch.api.notification.BatchNotificationListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.Synchronize;
import org.mule.api.context.notification.ServerNotification;

public class BatchSynchronizeListener
implements BatchNotificationListener,
Synchronize {
    private AtomicBoolean receivedBatchNotification = new AtomicBoolean(false);
    private AtomicInteger inputPhaseCounter = new AtomicInteger(Integer.MAX_VALUE);
    private AtomicInteger loadPhaseCounter = new AtomicInteger(Integer.MAX_VALUE);
    private AtomicInteger jobPhaseCounter = new AtomicInteger(Integer.MAX_VALUE);
    private AtomicInteger onCompletePhaseCounter = new AtomicInteger(Integer.MAX_VALUE);

    public synchronized void onNotification(ServerNotification serverNotification) {
        int action = serverNotification.getAction();
        if (action == BatchNotification.LOAD_PHASE_PROGRESS || action == BatchNotification.STEP_RECORD_START || action == BatchNotification.STEP_RECORD_FAILED || action == BatchNotification.STEP_RECORD_END || action == BatchNotification.STEP_COMMIT_START || action == BatchNotification.STEP_COMMIT_END || action == BatchNotification.STEP_RECORD_FAILED || action == BatchNotification.PROGRESS_UPDATE) {
            return;
        }
        if (action == BatchNotification.INPUT_PHASE_BEGIN) {
            this.receivedBatchNotification.set(true);
            this.increment(this.inputPhaseCounter);
        } else if (action == BatchNotification.INPUT_PHASE_END || action == BatchNotification.INPUT_PHASE_FAILED) {
            this.inputPhaseCounter.decrementAndGet();
        } else if (action == BatchNotification.LOAD_PHASE_BEGIN) {
            this.increment(this.loadPhaseCounter);
        } else if (action == BatchNotification.LOAD_PHASE_END || action == BatchNotification.LOAD_PHASE_FAILED) {
            this.loadPhaseCounter.decrementAndGet();
        } else if (action == BatchNotification.JOB_PROCESS_RECORDS_BEGIN) {
            this.increment(this.jobPhaseCounter);
        } else if (action == BatchNotification.JOB_PROCESS_RECORDS_FAILED || action == BatchNotification.JOB_CANCELLED || action == BatchNotification.JOB_SUCCESSFUL || action == BatchNotification.JOB_STOPPED) {
            this.jobPhaseCounter.decrementAndGet();
        } else if (action == BatchNotification.ON_COMPLETE_BEGIN) {
            this.increment(this.onCompletePhaseCounter);
        } else if (action == BatchNotification.ON_COMPLETE_END || action == BatchNotification.ON_COMPLETE_FAILED) {
            this.onCompletePhaseCounter.decrementAndGet();
        }
    }

    private synchronized void increment(AtomicInteger counter) {
        if (counter.get() == Integer.MAX_VALUE) {
            counter.set(1);
        } else {
            counter.incrementAndGet();
        }
    }

    @Override
    public synchronized boolean readyToContinue() {
        return !this.receivedBatchNotification.get() || this.inputPhaseCounter.get() <= 0 && this.loadPhaseCounter.get() <= 0 && this.jobPhaseCounter.get() <= 0 && this.onCompletePhaseCounter.get() <= 0;
    }
}

