/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package psft.pt8.joa;

import com.mulesoft.peoplesoft.exception.PeopleSoftException;

public class PeopleSoftCICollectionHelper {

    public static boolean isInstanceOfCICollection(Object object) {
        return object instanceof CICollection;
    }

    private CICollection collection;

    public PeopleSoftCICollectionHelper(Object collection) {
        if (collection == null) {
            throw new PeopleSoftException(PeopleSoftCICollectionHelper.class.getName() + " requires a CICollection object. No null value allowed");
        } else if (!(collection instanceof CICollection)) {
            throw new PeopleSoftException(PeopleSoftCICollectionHelper.class.getName() + " requires a CICollection object as input. Entered: " + collection.getClass().getName());
        }

        this.collection = (CICollection) collection;
    }


    public long getCount() {
        return collection.getCount();
    }

    public PeopleSoftCIHelper item(long index) {
        return new PeopleSoftCIHelper(collection.item(index));
    }
}
