/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package psft.pt8.joa;

import com.mulesoft.peoplesoft.exception.PeopleSoftException;

public class PeopleSoftCIRowHelper {

    private CIRow row;

    public PeopleSoftCIRowHelper(Object row) {
        if (row == null) {
            throw new PeopleSoftException(PeopleSoftCIHelper.class.getName() + " requires a CIRow object. No null value allowed");
        } else if (!(row instanceof CIRow)) {
            throw new PeopleSoftException(PeopleSoftCIHelper.class.getName() + " requires a CIRow object as input. Entered: " + row.getClass().getName());
        }

        this.row = (CIRow) row;
    }

    public CIItem getItem() {
        return row.getItem();
    }

    public Object getProperty(String name) {
        try {
            return row.getPropertyByName(name);
        } catch (JOAException e) {
            throw new PeopleSoftException(row.getParent().getNamespaceName() + " - can not find property by name " + name, e);
        }
    }


    public int getPropertyCount() {
        return row.getPropertyCount();
    }


    public IObject getPropertyInfoByName(String name) {
        try {
            return row.getPropertyInfoByName(name);
        } catch (JOAException e) {
            throw new PeopleSoftException(e);
        }
    }

    public long setProperty(String name, Object value) {
        try {
            return row.setPropertyByName(name, value);
        } catch (JOAException e) {
            throw new PeopleSoftException("Error setting property " + name + " with value " + value.toString(), e);
        }
    }
}
