/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package psft.pt8.joa;

import com.mulesoft.peoplesoft.exception.PeopleSoftException;

public class PeopleSoftCIScrollHelper {

    private CIScroll scroll;

    public PeopleSoftCIScrollHelper(Object scroll) {
        if (scroll == null) {
            throw new PeopleSoftException(PeopleSoftCIHelper.class.getName() + " requires a CIScroll object. No null value allowed");
        } else if (!(scroll instanceof CIScroll)) {
            throw new PeopleSoftException(PeopleSoftCIHelper.class.getName() + " requires a CIScroll object as input. Entered: " + scroll.getClass().getName());
        }

        this.scroll = (CIScroll) scroll;
    }


    public long getCount() {
        try {
            return scroll.getCount();
        } catch (JOAException e) {
            throw new PeopleSoftException(e);
        }
    }


    public Object item(long index) {
        try {
            return scroll.item(index);
        } catch (JOAException e) {
            throw new PeopleSoftException(e);
        }
    }
}
