/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package psft.pt8.joa;

import com.mulesoft.peoplesoft.exception.PeopleSoftException;

public class PeopleSoftPICollectionHelper extends PeopleSoftPIInternalCache<PeopleSoftPIHelper> {

    private CIPropertyInfoCollection propInfoColl;
    private Long count;
    private boolean cacheInitialized;

    public PeopleSoftPICollectionHelper(Object propInfoColl) {
        if (propInfoColl == null) {
            throw new PeopleSoftException(PeopleSoftPICollectionHelper.class.getName() + " requires a CIPropertyInfoCollection object. No null value allowed");
        } else if (!(propInfoColl instanceof CIPropertyInfoCollection)) {
            throw new PeopleSoftException(PeopleSoftPICollectionHelper.class.getName() + " requires a CIPropertyInfoCollection object.. Entered: "
                    + propInfoColl.getClass().getName());
        }

        this.propInfoColl = (CIPropertyInfoCollection) propInfoColl;
        count = null;
    }

    /**
     * Each time an item info is requested one call to the server is made, so to evade that we initialize all the
     * properties first and store them in an internal cache
     */
    public synchronized void initializeCache() {
        if (!cacheInitialized) {
            PeopleSoftPIHelper item = null;
            for (long x = 0, xMax = count(); x < xMax; x++) {
                try {
                    item = new PeopleSoftPIHelper(propInfoColl.item(x));
                } catch (JOAException e) {
                    throw new PeopleSoftException("Failed during cache initialization of property info", e);
                }

                super.putByIndexAndName(x, item.getName(), item);

                if (item.getIsCollection()) {
                    // If it's a collection, start the cache initialization for it also
                    item.getPropertyInfoCollection().initializeCache();
                }
            }
            cacheInitialized = true;
        }
    }

    public long count() {
        if (count == null) {
            count = propInfoColl.getCount();
        }

        return count;
    }

    public PeopleSoftPIHelper getItemAt(long index) {
        initializeCache();
        if (super.isIndexInCache(index)) {
            return super.getByIndex(index);
        } else {
            return null;
        }
    }

    public PeopleSoftPIHelper getItemByName(String name) {
        // Check if cache is not initialized. Consume only the elements from the cache
        initializeCache();
        if (super.isNameInCache(name)) {
            return super.getByName(name);
        } else {
            return null;
        }
    }

    public String toJson() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (long x = 0, xMax = count(); x < xMax; x++) {
            if (x > 0) {
                sb.append(",");
            }

            PeopleSoftPIHelper itemAt = getItemAt(x);
            sb.append(itemAt.toJson());
        }
        sb.append("]");

        return sb.toString();
    }
}
