/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package psft.pt8.joa;

import com.mulesoft.peoplesoft.exception.PeopleSoftException;

/**
 * PeopleSoft PropertyInfo helper class.
 */
public class PeopleSoftPIHelper {

    private CIPropertyInfo propInfo;
    private PeopleSoftPICollectionHelper propertyInfoCollection;

    public PeopleSoftPIHelper(Object propInfo) {
        if (propInfo == null) {
            throw new PeopleSoftException(PeopleSoftPIHelper.class.getName() + " requires a CIPropertyInfo object. No null value allowed");
        } else if (!(propInfo instanceof CIPropertyInfo)) {
            throw new PeopleSoftException(PeopleSoftPIHelper.class.getName() + " requires a CIPropertyInfo object.. Entered: "
                    + propInfo.getClass().getName());
        }

        this.propInfo = (CIPropertyInfo) propInfo;
    }

    /**
     * Convenience function for getting decimal position of CIPropertyInfo.
     * @return The value.
     */
    public long getDecimalPosition() {
        return propInfo.getDecimalPosition();
    }

    /**
     * Convenience function for getting field name of CIPropertyInfo.
     * @return The field name.
     */
    public String getFieldName() {
        return propInfo.getFieldName();
    }

    /**
     * Convenience function for getting format of CIPropertyInfo.
     * @return The value.
     */
    public long getFormat() {
        return propInfo.getFormat();
    }

    /**
     * Convenience function to check whether CIPropertyInfo is a Collection.
     * @return The value.
     */
    public boolean getIsCollection() {
        return propInfo.getIsCollection();
    }

    /**
     * Check CIPropertyInfo is read only.
     * @return The value.
     */
    public boolean getIsReadOnly() {
        return propInfo.getIsReadOnly();
    }

    /**
     * Extract the key of CIPropertyInfo.
     * @return The value.
     */
    public boolean getKey() {
        return propInfo.getKey();
    }

    /**
     * Extract the Label from CIPropertyInfo as Long.
     * @return The value.
     */
    public String getLabelLong() {
        return propInfo.getLabelLong();
    }

    /**
     * Extract the Label from CIPropertyInfo as Short.
     * @return The value.
     */
    public String getLabelShort() {
        return propInfo.getLabelShort();
    }

    /**
     * Extract the length from CIPropertyInfo as Long.
     * @return The value.
     */
    public long getLength() {
        return propInfo.getLength();
    }

    /**
     * Get the name from CIPropertyInfo.
     * @return The value.
     */
    public String getName() {
        return propInfo.getName();
    }

    /**
     * Get the prompt from CIPropertyInfo.
     * @return The value.
     */
    public boolean getPrompt() {
        return propInfo.getPrompt();
    }

    /**
     * Get the collection of CIPropertyInfo.
     * @return The value.
     */
    public PeopleSoftPICollectionHelper getPropertyInfoCollection() {
        // This value must be stored in cache
        if (propertyInfoCollection == null) {
            propertyInfoCollection = new PeopleSoftPICollectionHelper(propInfo.getPropertyInfoCollection());
        }

        return propertyInfoCollection;
    }

    /**
     * Get record name.
     * @return The value.
     */
    public String getRecordName() {
        return propInfo.getRecordName();
    }

    /**
     * Check whether the CIPropertyInfo is required.
     * @return The value.
     */
    public boolean getRequired() {
        return propInfo.getRequired();
    }

    /**
     * Get type of CIPropertyInfo.
     * @return The value.
     */
    public long getType() {
        return propInfo.getType();
    }

    /**
     * Get Xlat of CIPropertyInfo.
     * @return The value.
     */
    public boolean getXlat() {
        return propInfo.getXlat();
    }

    /**
     * Get Yesno of CIPropertyInfo.
     * @return The value.
     */
    public boolean getYesno() {
        return propInfo.getYesno();
    }

    /**
     * Convert CIPropertyInfo to JSON Object.
     * @return The value.
     */
    public String toJson() {
        if (getIsCollection()) {
            PeopleSoftPICollectionHelper infoCollection = getPropertyInfoCollection();
            return "{" +
                    "\"getName\":\"" + propInfo.getName() + "\"," +
                    "\"getRecordName\":\"" + propInfo.getRecordName() + "\"," +
                    "\"getRequired\":\"" + propInfo.getRequired() + "\"," +
                    "\"collection\":" + infoCollection.toJson() +
                    "}";
        } else {
            return "{" +
                    "\"getName\":\"" + propInfo.getName() + "\"," +
                    "\"getRecordName\":\"" + propInfo.getRecordName() + "\"," +
                    "\"getFieldName\":\"" + propInfo.getFieldName() + "\"," +
                    "\"getLabelLong\":\"" + propInfo.getLabelLong() + "\"," +
                    "\"getLabelShort\":\"" + propInfo.getLabelShort() + "\"," +
                    "\"getIsCollection\":\"" + propInfo.getIsCollection() + "\"," +
                    "\"getType\":\"" + propInfo.getType() + "\"," +
                    "\"getFormat\":\"" + propInfo.getFormat() + "\"," +
                    "\"getKey\":\"" + propInfo.getKey() + "\"," +
                    "\"getRequired\":\"" + propInfo.getRequired() + "\"," +
                    "\"getXlat\":\"" + propInfo.getXlat() + "\"," +
                    "\"getYesno\":\"" + propInfo.getYesno() + "\"," +
                    "\"getPrompt\":\"" + propInfo.getPrompt() + "\"," +
                    "\"getLength\":\"" + propInfo.getLength() + "\"," +
                    "\"getDecimalPosition\":\"" + propInfo.getDecimalPosition() + "\"," +
                    "\"getIsReadOnly\":\"" + propInfo.getIsReadOnly() + "\"" +
                    "}";
        }
    }
}
