/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package psft.pt8.joa;

import java.util.HashMap;
import java.util.Map;

class PeopleSoftPIInternalCache<T> {

    private Map<String, T> nameCache;
    private Map<Long, T> indexCache;

    public PeopleSoftPIInternalCache() {
        nameCache = new HashMap<String, T>();
        indexCache = new HashMap<Long, T>();
    }

    protected boolean isIndexInCache(Long index) {
        return indexCache.containsKey(index);
    }

    protected boolean isNameInCache(String key) {
        return nameCache.containsKey(key);
    }

    protected T getByIndex(Long index) {
        return indexCache.get(index);
    }

    protected T getByName(String key) {
        return nameCache.get(key);
    }

    protected void putByIndexAndName(Long index, String name, T value) {
        nameCache.put(name, value);
        indexCache.put(index, value);
    }
}
