/*
 * Decompiled with CFR 0.152.
 */
package psft.pt8.joa;

import com.mulesoft.peoplesoft.exception.PeopleSoftException;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import psft.pt8.joa.CI;
import psft.pt8.joa.JOAException;
import psft.pt8.joa.PeopleSoftPICollectionHelper;

public class PeopleSoftCIHelper {
    private static final Logger logger = Logger.getLogger(PeopleSoftCIHelper.class);
    private CI ci;

    public PeopleSoftCIHelper(Object ci) {
        if (ci == null) {
            throw new PeopleSoftException(PeopleSoftCIHelper.class.getName() + " requires a CI object. No null value allowed");
        }
        if (!(ci instanceof CI)) {
            throw new PeopleSoftException(PeopleSoftCIHelper.class.getName() + " requires a CI object as input. Entered: " + ci.getClass().getName());
        }
        this.ci = (CI)ci;
    }

    public void setInteractiveMode(boolean inInteractiveMode) {
        try {
            this.ci.setProperty("InteractiveMode", (Object)inInteractiveMode);
        }
        catch (JOAException e) {
            throw new PeopleSoftException(e);
        }
    }

    public void setGetHistoryItems(boolean inGetHistoryItems) {
        try {
            this.ci.setProperty("GetHistoryItems", (Object)inGetHistoryItems);
        }
        catch (JOAException e) {
            throw new PeopleSoftException(e);
        }
    }

    public void setEditHistoryItems(boolean inEditHistoryItems) {
        try {
            this.ci.setProperty("EditHistoryItems", (Object)inEditHistoryItems);
        }
        catch (JOAException e) {
            throw new PeopleSoftException(e);
        }
    }

    public Set<String> getSupportedOperations() {
        try {
            Field authMethods = this.ci.getClass().getDeclaredField("m_setAuthorizedMethods");
            authMethods.setAccessible(true);
            return (Set)authMethods.get(this.ci);
        }
        catch (NoSuchFieldException e) {
            throw new PeopleSoftException("Can not find attribute with authorized methods", e);
        }
        catch (SecurityException e) {
            throw new PeopleSoftException("Can not access attribute with authorized methods", e);
        }
        catch (IllegalArgumentException e) {
            throw new PeopleSoftException(e);
        }
        catch (IllegalAccessException e) {
            throw new PeopleSoftException(e);
        }
    }

    public PeopleSoftPICollectionHelper getPropertyInfoCollection() {
        try {
            PeopleSoftPICollectionHelper peopleSoftPropertyInfoCollectionHelper = new PeopleSoftPICollectionHelper(this.ci.getProperty("PropertyInfoCollection"));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)peopleSoftPropertyInfoCollectionHelper.toJson());
            }
            return peopleSoftPropertyInfoCollectionHelper;
        }
        catch (JOAException e) {
            throw new PeopleSoftException("Can not get PropertyInfoCollection for CI " + this.ci.getNamespaceName(), e);
        }
    }

    public PeopleSoftPICollectionHelper getCreateKeyInfoCollection() {
        try {
            PeopleSoftPICollectionHelper peopleSoftPropertyInfoCollectionHelper = new PeopleSoftPICollectionHelper(this.ci.getProperty("CreateKeyInfoCollection"));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)peopleSoftPropertyInfoCollectionHelper.toJson());
            }
            return peopleSoftPropertyInfoCollectionHelper;
        }
        catch (JOAException e) {
            throw new PeopleSoftException("Can not get CreateKeyInfoCollection for CI " + this.ci.getNamespaceName(), e);
        }
    }

    public PeopleSoftPICollectionHelper getGetKeyInfoCollection() {
        try {
            PeopleSoftPICollectionHelper peopleSoftPropertyInfoCollectionHelper = new PeopleSoftPICollectionHelper(this.ci.getProperty("GetKeyInfoCollection"));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)peopleSoftPropertyInfoCollectionHelper.toJson());
            }
            return peopleSoftPropertyInfoCollectionHelper;
        }
        catch (JOAException e) {
            throw new PeopleSoftException("Can not get GetKeyInfoCollection for CI " + this.ci.getNamespaceName(), e);
        }
    }

    public PeopleSoftPICollectionHelper getFindKeyInfoCollection() {
        try {
            PeopleSoftPICollectionHelper peopleSoftPropertyInfoCollectionHelper = new PeopleSoftPICollectionHelper(this.ci.getProperty("FindKeyInfoCollection"));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)peopleSoftPropertyInfoCollectionHelper.toJson());
            }
            return peopleSoftPropertyInfoCollectionHelper;
        }
        catch (JOAException e) {
            throw new PeopleSoftException("Can not get FindKeyInfoCollection for CI " + this.ci.getNamespaceName(), e);
        }
    }

    public void setProperty(String name, Object value) {
        try {
            this.ci.setProperty(name, value);
        }
        catch (JOAException e) {
            throw new PeopleSoftException("Can not set property " + name + " on CI " + this.ci.getNamespaceName(), e);
        }
    }

    public Map<String, Object> getProperties() {
        try {
            Field entitiesMap = this.ci.getClass().getDeclaredField("m_mapKeys");
            entitiesMap.setAccessible(true);
            return (Map)entitiesMap.get(this.ci);
        }
        catch (NoSuchFieldException e) {
            throw new PeopleSoftException("Can not find attribute with entities map", e);
        }
        catch (SecurityException e) {
            throw new PeopleSoftException("Can not access attribute with entities map", e);
        }
        catch (IllegalArgumentException e) {
            throw new PeopleSoftException(e);
        }
        catch (IllegalAccessException e) {
            throw new PeopleSoftException(e);
        }
    }

    public Object getProperty(String name) {
        try {
            return this.ci.getProperty(name);
        }
        catch (JOAException e) {
            throw new PeopleSoftException(e);
        }
    }

    public Object invokeMethod(String method) {
        try {
            Object invokeMethod = this.ci.invokeMethod(method, new Object[0]);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("InvokeMethod response " + invokeMethod));
            }
            return invokeMethod;
        }
        catch (JOAException e) {
            throw new PeopleSoftException(e);
        }
    }
}

