/*
 * Decompiled with CFR 0.152.
 */
package psft.pt8.joa;

import com.mulesoft.peoplesoft.exception.PeopleSoftException;
import psft.pt8.joa.CIItem;
import psft.pt8.joa.CIRow;
import psft.pt8.joa.IObject;
import psft.pt8.joa.JOAException;
import psft.pt8.joa.PeopleSoftCIHelper;

public class PeopleSoftCIRowHelper {
    private CIRow row;

    public PeopleSoftCIRowHelper(Object row) {
        if (row == null) {
            throw new PeopleSoftException(PeopleSoftCIHelper.class.getName() + " requires a CIRow object. No null value allowed");
        }
        if (!(row instanceof CIRow)) {
            throw new PeopleSoftException(PeopleSoftCIHelper.class.getName() + " requires a CIRow object as input. Entered: " + row.getClass().getName());
        }
        this.row = (CIRow)row;
    }

    public CIItem getItem() {
        return this.row.getItem();
    }

    public Object getProperty(String name) {
        try {
            return this.row.getPropertyByName(name);
        }
        catch (JOAException e) {
            throw new PeopleSoftException(this.row.getParent().getNamespaceName() + " - can not find property by name " + name, e);
        }
    }

    public int getPropertyCount() {
        return this.row.getPropertyCount();
    }

    public IObject getPropertyInfoByName(String name) {
        try {
            return this.row.getPropertyInfoByName(name);
        }
        catch (JOAException e) {
            throw new PeopleSoftException(e);
        }
    }

    public long setProperty(String name, Object value) {
        try {
            return this.row.setPropertyByName(name, value);
        }
        catch (JOAException e) {
            throw new PeopleSoftException("Error setting property " + name + " with value " + value.toString(), e);
        }
    }
}

