/*
 * Decompiled with CFR 0.152.
 */
package psft.pt8.joa;

import com.mulesoft.peoplesoft.exception.PeopleSoftException;
import psft.pt8.joa.CIPropertyInfoCollection;
import psft.pt8.joa.JOAException;
import psft.pt8.joa.PeopleSoftPIHelper;
import psft.pt8.joa.PeopleSoftPIInternalCache;

public class PeopleSoftPICollectionHelper
extends PeopleSoftPIInternalCache<PeopleSoftPIHelper> {
    private CIPropertyInfoCollection propInfoColl;
    private Long count;
    private boolean cacheInitialized;

    public PeopleSoftPICollectionHelper(Object propInfoColl) {
        if (propInfoColl == null) {
            throw new PeopleSoftException(PeopleSoftPICollectionHelper.class.getName() + " requires a CIPropertyInfoCollection object. No null value allowed");
        }
        if (!(propInfoColl instanceof CIPropertyInfoCollection)) {
            throw new PeopleSoftException(PeopleSoftPICollectionHelper.class.getName() + " requires a CIPropertyInfoCollection object.. Entered: " + propInfoColl.getClass().getName());
        }
        this.propInfoColl = (CIPropertyInfoCollection)propInfoColl;
        this.count = null;
    }

    public synchronized void initializeCache() {
        if (!this.cacheInitialized) {
            PeopleSoftPIHelper item = null;
            long xMax = this.count();
            for (long x = 0L; x < xMax; ++x) {
                try {
                    item = new PeopleSoftPIHelper(this.propInfoColl.item(x));
                }
                catch (JOAException e) {
                    throw new PeopleSoftException("Failed during cache initialization of property info", e);
                }
                super.putByIndexAndName(x, item.getName(), item);
                if (!item.getIsCollection()) continue;
                item.getPropertyInfoCollection().initializeCache();
            }
            this.cacheInitialized = true;
        }
    }

    public long count() {
        if (this.count == null) {
            this.count = this.propInfoColl.getCount();
        }
        return this.count;
    }

    public PeopleSoftPIHelper getItemAt(long index) {
        this.initializeCache();
        if (super.isIndexInCache(index)) {
            return (PeopleSoftPIHelper)super.getByIndex(index);
        }
        return null;
    }

    public PeopleSoftPIHelper getItemByName(String name) {
        this.initializeCache();
        if (super.isNameInCache(name)) {
            return (PeopleSoftPIHelper)super.getByName(name);
        }
        return null;
    }

    public String toJson() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        long xMax = this.count();
        for (long x = 0L; x < xMax; ++x) {
            if (x > 0L) {
                sb.append(",");
            }
            PeopleSoftPIHelper itemAt = this.getItemAt(x);
            sb.append(itemAt.toJson());
        }
        sb.append("]");
        return sb.toString();
    }
}

