/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.ang.introspector.benchmark;

import com.mulesoft.runtime.ang.introspector.MuleApplicationAngFn;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Threads;
import org.slf4j.LoggerFactory;

@OutputTimeUnit(value=TimeUnit.SECONDS)
@Threads(value=1)
public class MuleArtifactAngDataExtractorBenchmark {
    @Benchmark
    public String processSampleAppForceParse() throws IOException {
        System.setProperty("mule.angis.forceConfigParse", Boolean.TRUE.toString());
        try {
            String string = this.processApp("schedulersSampleApp");
            return string;
        }
        finally {
            System.clearProperty("mule.angis.forceConfigParse");
        }
    }

    @Benchmark
    public String processSampleAppWithPropertiesForceParse() throws IOException {
        System.setProperty("mule.angis.forceConfigParse", Boolean.TRUE.toString());
        try {
            String string = this.processApp("schedulersWithPropertiesSampleApp");
            return string;
        }
        finally {
            System.clearProperty("mule.angis.forceConfigParse");
        }
    }

    @Benchmark
    public String processSampleApp() throws IOException {
        return this.processApp("schedulersSampleApp");
    }

    @Benchmark
    public String processSampleAppWithProperties() throws IOException {
        return this.processApp("schedulersWithPropertiesSampleApp");
    }

    private String processApp(String appToIntrospect) throws IOException {
        File appFile = new File(System.getProperty(appToIntrospect));
        try (ByteArrayInputStream muleAppJarFileContentStream = new ByteArrayInputStream(Files.readAllBytes(appFile.toPath()));){
            String string = new MuleApplicationAngFn(LoggerFactory.getLogger(MuleArtifactAngDataExtractorBenchmark.class)).handle(appFile.getName(), (InputStream)muleAppJarFileContentStream, new HashMap());
            return string;
        }
    }
}

