/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.ang.classpath;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

/** A {@link URLStreamHandler} that handles resources on the classpath. */
public class ClasspathHandler extends URLStreamHandler {

  /** The classloader to find resources from. */
  private final ClassLoader classLoader;

  public ClasspathHandler() {
    this.classLoader = getClass().getClassLoader();
  }

  public ClasspathHandler(ClassLoader classLoader) {
    this.classLoader = classLoader;
  }

  @Override
  protected URLConnection openConnection(URL u) throws IOException {
    final URL resourceUrl = classLoader.getResource(u.getPath());
    return resourceUrl.openConnection();
  }
}
