/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.ang.classpath;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.HashMap;
import java.util.Map;

public class ConfigurableStreamHandlerFactory implements URLStreamHandlerFactory {

  private final Map<String, URLStreamHandler> protocolHandlers;

  public ConfigurableStreamHandlerFactory(String protocol, URLStreamHandler urlHandler) {
    protocolHandlers = new HashMap<>();
    addHandler(protocol, urlHandler);
  }

  public void addHandler(String protocol, URLStreamHandler urlHandler) {
    protocolHandlers.put(protocol, urlHandler);
  }

  @Override
  public URLStreamHandler createURLStreamHandler(String protocol) {
    return protocolHandlers.get(protocol);
  }
}
