/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.ang.classpath;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mulesoft.runtime.ang.classpath.ClasspathHandler;
import com.mulesoft.runtime.ang.classpath.ConfigurableStreamHandlerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.internal.DefaultModuleRepository;
import org.mule.runtime.container.internal.ModuleDiscoverer;

public class ModuleRepositoryGenerator {
    private static final String MODULE_REPOSITORY_JSON = "module-repository.json";

    public static void main(String[] args) throws IOException {
        new ModuleRepositoryGenerator().generate(new File(args[0]));
    }

    public void generate(File outputFolder) throws IOException {
        File temporaryFolder = new File(outputFolder, "moduleRepository");
        temporaryFolder.mkdir();
        ModuleRepository moduleRepository = ModuleRepository.createModuleRepository((ClassLoader)this.getClass().getClassLoader(), serviceInterface -> new File(temporaryFolder, (String)serviceInterface), (serviceInterface, serviceFile) -> {
            try {
                return new URL("classpath:" + serviceFile.getPath().substring(outputFolder.getAbsolutePath().length() + 1));
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(String.format("Error creating temporary service provider file for '%s'", serviceInterface), e);
            }
        });
        moduleRepository.getModules();
        File outputFile = new File(outputFolder, MODULE_REPOSITORY_JSON);
        if (outputFile.exists()) {
            outputFile.delete();
        }
        outputFile.createNewFile();
        try (OutputStreamWriter osw = new OutputStreamWriter(new FileOutputStream(outputFile));){
            osw.write(new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

                public boolean shouldSkipField(FieldAttributes f) {
                    return false;
                }

                public boolean shouldSkipClass(Class<?> clazz) {
                    return ModuleDiscoverer.class.isAssignableFrom(clazz);
                }
            }}).create().toJson((Object)moduleRepository));
        }
    }

    public ModuleRepository read() throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/module-repository.json")));){
            ModuleRepository moduleRepository = (ModuleRepository)new Gson().fromJson((Reader)reader, DefaultModuleRepository.class);
            return moduleRepository;
        }
    }

    static {
        URL.setURLStreamHandlerFactory(new ConfigurableStreamHandlerFactory("classpath", new ClasspathHandler()));
    }
}

