/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.ang.introspector;

import static com.mulesoft.runtime.ang.introspector.extractor.ConfigPropertiesDataExtractor.CONFIG_PROPERTIES_KEY;
import static com.mulesoft.runtime.ang.introspector.extractor.SchedulersDataExtractor.SCHEDULERS_KEY;

import org.mule.runtime.ast.api.ArtifactAst;

import com.mulesoft.runtime.ang.introspector.extractor.ConfigPropertiesDataExtractor;
import com.mulesoft.runtime.ang.introspector.extractor.SchedulersDataExtractor;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Provides the logic to extract data form an {@link ArtifactAst} into the format defined by an AML dialect to be published to
 * ANG.
 */
public class MuleArtifactAngDataExtractor {

  private final SchedulersDataExtractor schedulersDataExtractor = new SchedulersDataExtractor();
  private final ConfigPropertiesDataExtractor configPropertiesDataExtractor = new ConfigPropertiesDataExtractor();

  /**
   * Extracts the required data.
   * 
   * @param artifact the artifact to extract data from.
   * @return the raw data to be published into ANG.
   */
  public Map<String, Object> extractFrom(ArtifactAst artifact) {
    Map<String, Object> extracted = new LinkedHashMap<>();

    extracted.put(SCHEDULERS_KEY, schedulersDataExtractor.extractFrom(artifact));
    extracted.put(CONFIG_PROPERTIES_KEY, configPropertiesDataExtractor.extractFrom(artifact));

    return extracted;
  }

}
