/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.ang.introspector;

import com.mulesoft.runtime.ang.introspector.MuleApplicationAngFn;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.contrib.java.lang.system.ProvideSystemProperty;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.runtime.module.artifact.api.descriptor.InvalidDescriptorLoaderException;
import org.slf4j.LoggerFactory;

@Feature(value="Introspection")
@Story(value="Schedulers Data Extraction")
@RunWith(value=Parameterized.class)
public class MuleArtifactAngDataExtractorTestCase {
    @Rule
    public ProvideSystemProperty forceParse;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Boolean> params() {
        return Arrays.asList(true, false);
    }

    public MuleArtifactAngDataExtractorTestCase(Boolean forceConfigParse) {
        this.forceParse = new ProvideSystemProperty("mule.angis.forceConfigParse", forceConfigParse.toString());
    }

    @Test
    public void extractedDataFromSampleAppMatchesExpectedOutput() throws IllegalArgumentException, FileNotFoundException, IOException, InvalidDescriptorLoaderException {
        this.assertIntrospection("schedulersSampleApp", "schedulers-example.yaml", "schedulers-sample");
    }

    @Test
    @Issue(value="EE-7894")
    @Story(value="Config Properties Data Extraction")
    public void extractedDataFromSampleAppWithPropertiesMatchesExpectedOutput() throws IllegalArgumentException, FileNotFoundException, IOException, InvalidDescriptorLoaderException {
        this.assertIntrospection("schedulersWithPropertiesSampleApp", "schedulers-with-properties-example.yaml", "schedulers-with-properties-sample");
    }

    @Test
    @Issue(value="EE-8059")
    @Ignore(value="MMP-581")
    public void extractedDataFromSampleAppWithImportMatchesExpectedOutput() throws IllegalArgumentException, FileNotFoundException, IOException, InvalidDescriptorLoaderException {
        this.assertIntrospection("schedulersSampleAppWithImport", "schedulers-example.yaml", "schedulers-sample-with-import");
    }

    private void assertIntrospection(String appToIntrospect, String expectedDocument, String assetId) throws IOException {
        LinkedHashMap<String, String> base = new LinkedHashMap<String, String>();
        base.put("organizationId", "Runtime");
        base.put("groupId", "com.mulesoft.runtime.ang");
        base.put("assetId", assetId);
        base.put("semverVersion", "1.0.0");
        File appFile = new File(System.getProperty(appToIntrospect));
        try (FileInputStream muleAppJarFileContent = new FileInputStream(appFile);){
            String handled = new MuleApplicationAngFn(LoggerFactory.getLogger(MuleArtifactAngDataExtractorTestCase.class)).handle(appFile.getName(), (InputStream)muleAppJarFileContent, base);
            MatcherAssert.assertThat((Object)handled, (Matcher)Is.is((Object)IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(expectedDocument), (Charset)StandardCharsets.UTF_8)));
        }
    }
}

