/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.ang.introspector;

import com.mulesoft.runtime.ang.introspector.MuleArtifactAstLoader;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.core.api.util.FileUtils;
import org.slf4j.LoggerFactory;

@Feature(value="Introspection")
@Story(value="Artifact AST Loading")
public class MuleArtifactAstLoaderTestCase {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private File expandedAppFolder;
    private ModuleRepository moduleRepository;

    @Before
    public void before() throws IOException {
        this.expandedAppFolder = this.tempFolder.newFolder();
        this.moduleRepository = ModuleRepository.createModuleRepository((ClassLoader)this.getClass().getClassLoader(), (File)this.tempFolder.newFolder());
    }

    @Test
    public void loadArtifactAst() throws IOException {
        FileUtils.unzip((File)new File(System.getProperty("schedulersSampleApp")), (File)this.expandedAppFolder);
        MatcherAssert.assertThat((Object)this.getMuleArtifactAstLoader(true).loadFromArtifact(this.expandedAppFolder), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void deserializeArtifactAst() throws IOException {
        FileUtils.unzip((File)new File(System.getProperty("schedulersSampleApp")), (File)this.expandedAppFolder);
        MatcherAssert.assertThat((Object)this.getMuleArtifactAstLoader(false).loadFromArtifact(this.expandedAppFolder), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    @Issue(value="EE-8036")
    public void loadArtifactAstForAutogeneratedProxy() throws IOException {
        FileUtils.unzip((InputStream)MuleArtifactAstLoaderTestCase.class.getResourceAsStream("/american_flight_api-v1-Rate_limiting_SLA_police.jar"), (File)this.expandedAppFolder);
        MatcherAssert.assertThat((Object)this.getMuleArtifactAstLoader(false).loadFromArtifact(this.expandedAppFolder), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void loadArtifactAstForAppUsingRestConnectConnector() throws IOException {
        FileUtils.unzip((InputStream)MuleArtifactAstLoaderTestCase.class.getResourceAsStream("/rest-connect-munit-test-1.0.0-SNAPSHOT-mule-application.jar"), (File)this.expandedAppFolder);
        MatcherAssert.assertThat((Object)this.getMuleArtifactAstLoader(false).loadFromArtifact(this.expandedAppFolder), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void loadArtifactAstForAppUsingRestSdkConnector() throws IOException {
        FileUtils.unzip((InputStream)MuleArtifactAstLoaderTestCase.class.getResourceAsStream("/rest-sdk-chained-connectors-app-0.8.0-SNAPSHOT-mule-application.jar"), (File)this.expandedAppFolder);
        MatcherAssert.assertThat((Object)this.getMuleArtifactAstLoader(false).loadFromArtifact(this.expandedAppFolder), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
    }

    protected MuleArtifactAstLoader getMuleArtifactAstLoader(boolean forceConfigParse) {
        return new MuleArtifactAstLoader(this.moduleRepository, LoggerFactory.getLogger(MuleArtifactAstLoaderTestCase.class), forceConfigParse);
    }
}

