/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.ang.introspector.extractor;

import com.mulesoft.runtime.ang.introspector.extractor.ConfigPropertiesDataExtractor;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.function.Consumer;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Feature(value="Introspection")
@Story(value="Config Properties Data Extraction")
@Issue(value="EE-7893")
public class ConfigPropertiesDataExtractorTestCase {
    private final ConfigPropertiesDataExtractor extractor = new ConfigPropertiesDataExtractor();
    private Consumer<String> onProperty;

    @Before
    public void before() {
        this.onProperty = (Consumer)Mockito.mock(Consumer.class);
    }

    @Test
    public void noPropertyUsage() {
        this.extractor.findPropertyUsages("hello", this.onProperty);
        ((Consumer)Mockito.verify(this.onProperty, (VerificationMode)Mockito.never())).accept((String)ArgumentMatchers.any());
    }

    @Test
    public void simplePropertyUsage() {
        this.extractor.findPropertyUsages("${world}", this.onProperty);
        ((Consumer)Mockito.verify(this.onProperty)).accept((String)ArgumentMatchers.eq((Object)"world"));
    }

    @Test
    public void simplePropertyWithSpecialCharsUsage() {
        this.extractor.findPropertyUsages("${hello.@#$%^&world}", this.onProperty);
        ((Consumer)Mockito.verify(this.onProperty)).accept((String)ArgumentMatchers.eq((Object)"hello.@#$%^&world"));
    }

    @Test
    public void embeddedPropertyUsage() {
        this.extractor.findPropertyUsages("hello ${world}", this.onProperty);
        ((Consumer)Mockito.verify(this.onProperty)).accept((String)ArgumentMatchers.eq((Object)"world"));
    }

    @Test
    public void escapedPropertyUsage() {
        this.extractor.findPropertyUsages("\\${hello}", this.onProperty);
        ((Consumer)Mockito.verify(this.onProperty, (VerificationMode)Mockito.never())).accept((String)ArgumentMatchers.any());
    }

    @Test
    public void manyPropertiesUsage() {
        this.extractor.findPropertyUsages("${hello} ${world}", this.onProperty);
        ((Consumer)Mockito.verify(this.onProperty)).accept((String)ArgumentMatchers.eq((Object)"hello"));
        ((Consumer)Mockito.verify(this.onProperty)).accept((String)ArgumentMatchers.eq((Object)"world"));
    }
}

