/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.ang.introspector.extractor;

import com.mulesoft.runtime.ang.introspector.extractor.SchedulersDataExtractor;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsMapContaining;
import org.hamcrest.collection.IsMapWithSize;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;

@Feature(value="Introspection")
@Story(value="Schedulers Data Extraction")
public class SchedulersDataExtractorTestCase {
    private final SchedulersDataExtractor extractor = new SchedulersDataExtractor();
    private ComponentMetadataAst flowMetadata;
    private ComponentAst flow;
    private ComponentParameterAst schedulingStrategyParam;
    private ComponentAst src;

    @Before
    public void before() {
        this.flowMetadata = (ComponentMetadataAst)Mockito.mock(ComponentMetadataAst.class);
        this.flow = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)this.flow.getMetadata()).thenReturn((Object)this.flowMetadata);
        ComponentParameterAst maxConcurrencyParam = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)maxConcurrencyParam.getModel()).thenReturn((Object)((ParameterModel)Mockito.mock(ParameterModel.class)));
        Mockito.when((Object)this.flow.getParameter("General", "maxConcurrency")).thenReturn((Object)maxConcurrencyParam);
        this.schedulingStrategyParam = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        this.src = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)this.src.getParameter("General", "schedulingStrategy")).thenReturn((Object)this.schedulingStrategyParam);
    }

    @Test
    public void flowDescription() {
        Mockito.when((Object)this.flowMetadata.getDocAttributes()).thenReturn(Collections.singletonMap("description", "Flow description"));
        Mockito.when((Object)this.schedulingStrategyParam.getValue()).thenReturn((Object)Either.empty());
        MatcherAssert.assertThat((Object)this.extractor.extractFlowScheduler(this.flow, this.src), (Matcher)IsMapContaining.hasEntry((Object)"description", (Object)"Flow description"));
    }

    @Test
    public void flowNoDescription() {
        Mockito.when((Object)this.flowMetadata.getDocAttributes()).thenReturn(Collections.emptyMap());
        Mockito.when((Object)this.schedulingStrategyParam.getValue()).thenReturn((Object)Either.empty());
        Mockito.when((Object)this.src.getParameter("General", "schedulingStrategy")).thenReturn((Object)this.schedulingStrategyParam);
        MatcherAssert.assertThat((Object)this.extractor.extractFlowScheduler(this.flow, this.src), (Matcher)CoreMatchers.not((Matcher)IsMapContaining.hasKey((Object)"description")));
    }

    @Test
    public void unknownScheduler() {
        Mockito.when((Object)this.flowMetadata.getDocAttributes()).thenReturn(Collections.emptyMap());
        ComponentAst schedulingStrategy = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)schedulingStrategy.getIdentifier()).thenReturn((Object)ComponentIdentifier.builder().namespaceUri("http://anotherNamespace").namespace("another").name("anotherSchedulingStrategy").build());
        Mockito.when((Object)this.schedulingStrategyParam.getValue()).thenReturn((Object)Either.right((Object)schedulingStrategy));
        Mockito.when((Object)this.src.getParameter("General", "schedulingStrategy")).thenReturn((Object)this.schedulingStrategyParam);
        Map schedulerData = (Map)this.extractor.extractFlowScheduler(this.flow, this.src).get("scheduler");
        MatcherAssert.assertThat((Object)schedulerData, (Matcher)IsMapWithSize.anEmptyMap());
    }
}

