/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.ang.introspector;

import com.mulesoft.runtime.ang.classpath.ModuleRepositoryGenerator;
import com.mulesoft.runtime.ang.introspector.MuleArtifactAngDataExtractor;
import com.mulesoft.runtime.ang.introspector.MuleArtifactAstLoader;
import com.mulesoft.runtime.ang.introspector.exception.IntrospectorException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.UUID;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.core.api.util.FileUtils;
import org.slf4j.Logger;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class MuleApplicationAngFn {
    public static final String FORCE_CONFIG_PARSE_PROPERTY = "mule.angis.forceConfigParse";
    private final Logger log;
    private final Path workdir;
    private final ModuleRepository moduleRepository;
    private final MuleArtifactAngDataExtractor muleArtifactAngDataExtractor;

    public MuleApplicationAngFn(Logger log) {
        this.log = log;
        String workDirPrefix = UUID.randomUUID().toString();
        try {
            this.workdir = Files.createTempDirectory(workDirPrefix, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IntrospectorException(String.format("Unable to create work directory with prefix '%s'", workDirPrefix), e);
        }
        try {
            this.moduleRepository = new ModuleRepositoryGenerator().read();
        }
        catch (IOException e) {
            throw new IntrospectorException("Unable to read moduleRepository data.", e);
        }
        this.muleArtifactAngDataExtractor = new MuleArtifactAngDataExtractor();
    }

    public String handle(String appFileName, InputStream muleAppJarFileContent, Map<String, Object> baseAppData) {
        ArtifactAst artifact;
        this.log.info("Processing artifact '{}'...", (Object)appFileName);
        File appFolder = new File(this.workdir.toFile(), appFileName + UUID.randomUUID().toString());
        try {
            this.log.debug("Unzipping mule-application jar file...");
            FileUtils.unzip((InputStream)muleAppJarFileContent, (File)appFolder, (boolean)false, (boolean)false);
            this.log.debug("Loading artifact AST...");
            artifact = this.getMuleArtifactAstLoader().loadFromArtifact(appFolder);
        }
        catch (IOException e) {
            throw new IntrospectorException(String.format("Unable to unzip jar file '%s' into work directory '%s'", appFileName, appFolder.getAbsolutePath().toString()), e);
        }
        this.log.debug("Extracting data from AST...");
        baseAppData.putAll(this.getMuleArtifactAngDataExtractor().extractFrom(artifact));
        this.log.debug("Generating YAML with extracted data...");
        StringWriter outputWriter = new StringWriter();
        outputWriter.write("#%Application 1.0" + System.lineSeparator() + System.lineSeparator());
        MuleApplicationAngFn.createYaml().dump(baseAppData, (Writer)outputWriter);
        this.log.info("Finished processing artifact '{}'.", (Object)appFileName);
        return outputWriter.toString();
    }

    protected MuleArtifactAstLoader getMuleArtifactAstLoader() {
        return new MuleArtifactAstLoader(this.moduleRepository, this.log, Boolean.getBoolean(FORCE_CONFIG_PARSE_PROPERTY));
    }

    protected MuleArtifactAngDataExtractor getMuleArtifactAngDataExtractor() {
        return this.muleArtifactAngDataExtractor;
    }

    static Yaml createYaml() {
        DumperOptions options = new DumperOptions();
        options.setIndent(2);
        options.setPrettyFlow(true);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        return new Yaml(options);
    }

    public Path getWorkdir() {
        return this.workdir;
    }
}

