/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.ang.introspector;

import com.mulesoft.runtime.ang.introspector.extension.DefaultExtensionModelLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.serialization.ArtifactAstDeserializer;
import org.mule.runtime.ast.api.serialization.ArtifactAstSerializerProvider;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.dsl.api.ConfigResource;
import org.mule.runtime.module.deployment.impl.internal.maven.AbstractMavenClassLoaderModelLoader;
import org.slf4j.Logger;

public class MuleArtifactAstLoader {
    private static final String SERIALIZED_ARTIFACT_AST_LOCATION = "META-INF/mule-artifact/artifact.ast";
    private final ArtifactAstDeserializer astDeserializer;
    private final ModuleRepository moduleRepository;
    private final Logger log;
    private final boolean forceConfigParse;

    public MuleArtifactAstLoader(ModuleRepository moduleRepository, Logger log, boolean forceConfigParse) {
        this.moduleRepository = moduleRepository;
        this.astDeserializer = new ArtifactAstSerializerProvider().getDeserializer(false);
        this.log = log;
        this.forceConfigParse = forceConfigParse;
    }

    public ArtifactAst loadFromArtifact(File explodedAppDir) throws IllegalArgumentException, IOException {
        File serializedAstFile = new File(explodedAppDir, SERIALIZED_ARTIFACT_AST_LOCATION);
        File classloaderModelFile = new File(explodedAppDir, AbstractMavenClassLoaderModelLoader.CLASSLOADER_MODEL_JSON_DESCRIPTOR_LOCATION);
        if (!classloaderModelFile.exists()) {
            throw new IllegalArgumentException("Artifact does not contain a 'classloader-model.json' file. It must be a heavyweight package.");
        }
        return this.loadArtifactAst(explodedAppDir, serializedAstFile);
    }

    private ArtifactAst loadArtifactAst(File explodedAppDir, File serializedAstFile) throws IOException {
        Set<ExtensionModel> extensionModels;
        DefaultExtensionModelLoader loader;
        block13: {
            block12: {
                loader = new DefaultExtensionModelLoader(explodedAppDir, this.getClass().getClassLoader(), this.moduleRepository);
                extensionModels = loader.obtainExtensionModels();
                if (!this.forceConfigParse && serializedAstFile.exists()) {
                    this.log.info("Attempting to deserialize artifactAst present in artifact...");
                    Map extensionsByName = extensionModels.stream().collect(Collectors.toMap(ExtensionModel::getName, UnaryOperator.identity()));
                    try (FileInputStream artifactAstInputStream = new FileInputStream(serializedAstFile);){
                        ArtifactAst artifactAst = this.astDeserializer.deserialize((InputStream)artifactAstInputStream, extensionsByName::get);
                        return artifactAst;
                    }
                }
                if (!serializedAstFile.exists()) break block12;
                this.log.info("Ignoring serialized artifactAst present in artifact, parsing the config...");
                break block13;
            }
            this.log.info("Serialized artifactAst not present in artifact, parsing the config...");
        }
        ArtifactAst artifactAst = (ArtifactAst)ClassUtils.withContextClassLoader((ClassLoader)loader.getApplicationClassLoader(), () -> this.parseArtifactConfigFiles(explodedAppDir, loader.getApplicationDescriptor().getConfigResources(), extensionModels));
        return artifactAst;
        finally {
            loader.close();
        }
    }

    private ArtifactAst parseArtifactConfigFiles(File explodedAppDir, Set<String> configResources, Set<ExtensionModel> extensionModels) {
        AstXmlParser astXmlParser = AstXmlParser.builder().withExtensionModels(extensionModels).build();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        return astXmlParser.parse((ConfigResource[])configResources.stream().map(configResource -> {
            try {
                return new ConfigResource(configResource, tccl.getResource((String)configResource));
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Cannot load config file '%s'.", configResource), e);
            }
        }).toArray(ConfigResource[]::new));
    }
}

