/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.ang.introspector.extension;

import com.mulesoft.mule.runtime.bti.api.extension.BtiExtensionModelProvider;
import com.mulesoft.mule.runtime.core.api.extension.MuleEeExtensionModelProvider;
import com.mulesoft.mule.runtime.gw.autodiscovery.internal.AutodiscoveryExtensionModelProvider;
import com.mulesoft.mule.runtime.http.policy.api.extension.HttpPolicyEeExtensionModelProvider;
import com.mulesoft.mule.runtime.module.batch.api.extension.BatchExtensionModelProvider;
import com.mulesoft.mule.runtime.module.serialization.kryo.api.extension.KryoSerializerEeExtensionModelProvider;
import com.mulesoft.mule.runtime.tracking.api.extension.TrackingEeExtensionModelProvider;
import com.mulesoft.runtime.ang.introspector.extension.DefaultExtensionModelService;
import com.mulesoft.runtime.ang.introspector.extension.MuleArtifactResourcesRegistry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.container.api.ContainerClassLoaderProvider;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.extension.api.extension.XmlSdk1ExtensionModelProvider;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.DisposableClassLoader;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;

public class DefaultExtensionModelLoader
implements AutoCloseable {
    private static final LazyValue<Set<ExtensionModel>> RUNTIME_EXTENSION_MODELS = new LazyValue(() -> DefaultExtensionModelLoader.getRuntimeExtensionModels());
    private final ArtifactClassLoader containerClassLoader;
    private final LazyValue<ApplicationDescriptor> applicationDescriptor;
    private final LazyValue<MuleDeployableArtifactClassLoader> applicationClassLoader;
    private final DefaultExtensionModelService service;

    public static Set<ExtensionModel> getRuntimeExtensionModels() {
        ArrayList<Supplier<ExtensionModel>> runtimeExtensionModels = new ArrayList<Supplier<ExtensionModel>>();
        runtimeExtensionModels.add(() -> MuleExtensionModelProvider.getExtensionModel());
        runtimeExtensionModels.add(() -> MuleExtensionModelProvider.getTlsExtensionModel());
        runtimeExtensionModels.add(() -> XmlSdk1ExtensionModelProvider.getExtensionModel());
        runtimeExtensionModels.add(() -> MuleEeExtensionModelProvider.getExtensionModel());
        runtimeExtensionModels.add(() -> BatchExtensionModelProvider.getExtensionModel());
        runtimeExtensionModels.add(() -> BtiExtensionModelProvider.getExtensionModel());
        runtimeExtensionModels.add(() -> HttpPolicyEeExtensionModelProvider.getExtensionModel());
        runtimeExtensionModels.add(() -> KryoSerializerEeExtensionModelProvider.getExtensionModel());
        runtimeExtensionModels.add(() -> TrackingEeExtensionModelProvider.getExtensionModel());
        runtimeExtensionModels.add(() -> AutodiscoveryExtensionModelProvider.getExtensionModel());
        return runtimeExtensionModels.parallelStream().map(Supplier::get).collect(Collectors.toSet());
    }

    public DefaultExtensionModelLoader(File explodedAppDir, ClassLoader parentClassloader, ModuleRepository moduleRepository) throws IOException {
        this.containerClassLoader = ContainerClassLoaderProvider.createContainerClassLoader((ModuleRepository)moduleRepository, (ClassLoader)parentClassloader);
        MuleArtifactResourcesRegistry resourcesRegistry = new MuleArtifactResourcesRegistry(moduleRepository, this.containerClassLoader);
        this.applicationDescriptor = new LazyValue(() -> (ApplicationDescriptor)resourcesRegistry.getApplicationDescriptorFactory().create(explodedAppDir, Optional.empty()));
        this.applicationClassLoader = new LazyValue(() -> resourcesRegistry.getApplicationClassLoaderFactory().createApplicationClassLoader((ApplicationDescriptor)this.applicationDescriptor.get(), explodedAppDir));
        this.service = new DefaultExtensionModelService(resourcesRegistry, (Set)RUNTIME_EXTENSION_MODELS.get());
    }

    public Set<ExtensionModel> obtainExtensionModels() {
        return Stream.concat(((Set)RUNTIME_EXTENSION_MODELS.get()).stream(), this.service.loadExtensionsData(((MuleDeployableArtifactClassLoader)this.applicationClassLoader.get()).getArtifactPluginClassLoaders()).stream()).collect(Collectors.toSet());
    }

    @Override
    public void close() {
        this.applicationClassLoader.ifComputed(appCl -> {
            appCl.dispose();
            appCl.getArtifactPluginClassLoaders().forEach(DisposableClassLoader::dispose);
        });
        this.containerClassLoader.dispose();
    }

    public ApplicationDescriptor getApplicationDescriptor() {
        return (ApplicationDescriptor)this.applicationDescriptor.get();
    }

    public ClassLoader getApplicationClassLoader() {
        return (ClassLoader)this.applicationClassLoader.get();
    }
}

